/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	VillagerAI
**
** DESCRIPTION:	Villager AI
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef VILLAGER_AI_H
#define VILLAGER_AI_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "Behavior.h"
#include "VillagerSkills.h"
#include "VillagerPlans.h"

class CVillager;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CVillagerAI : public CVillagerPlans
{
	friend class CVillagerPlans;

private:

	//class data
	ldwUINT32				m_uiThinkTimer;

	//class methods
	//setup
	public:		void Reset(CVillager &Villager);

	//process
	public:		void Update(CVillager &Villager);

	private:	void DecideWhatToDo(CVillager &Villager);
	private:	const bool DecideOnIdleBehavior(CVillager &Villager);
	public:		const bool DecideOnChildBehavior(CVillager &Villager);
	private:	const bool DecideOnPregnantBehavior(CVillager &Villager);
	private:	const bool DecideOnStormyBehavior(CVillager &Villager);			
	private:	const bool DecideOnSickBehavior(CVillager &Villager);
	private:	const bool DecideOnExoticBehavior(CVillager &Villager);
	private:	const bool DecideOnEnlightenment(CVillager &Villager);
	private:	const bool DecideOnCuriousBehavior(CVillager &Villager);
	private:	const bool DecideOnRecreation(CVillager &Villager);
	private:	const bool DecideOnDayToDayBehavior(CVillager &Villager);
	private:	const bool DecideOnChiefBehavior(CVillager &Villager);
	public:		const ESkill DecideOnWorkSkill(CVillager &Villager);

	public:		const bool AttemptSkill(CVillager &Villager, const ESkill eSkill, const SSkillData sData = SSkillData());
	private:	const bool InitiatePredisposition(CVillager &Villager);
	private:	const bool InitiateChiefPredisposition(CVillager &Villager);
	public:	const bool InitiateWorkPlan(CVillager &Villager, ESkill whatSkill);

	public:		void RealtimeWorkDone(CVillager &Villager);
	protected:	void AdvanceState(CVillager &Villager, int whichState);

	public:		void DoBevMacInstantly(CVillager &Villager);
	
	public:		void AcquireTarget(CVillager &Villager, const int iTargetX, const int iTargetY, const ESpeed eSpeed);
	public:		void TakePosition(CVillager &Villager);
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/